/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class SectionCompiler {
    private final BlockRenderDispatcher blockRenderer;
    private final BlockEntityRenderDispatcher blockEntityRenderer;

    public SectionCompiler(BlockRenderDispatcher p_350768_, BlockEntityRenderDispatcher p_350715_) {
        this.blockRenderer = p_350768_;
        this.blockEntityRenderer = p_350715_;
    }

    public Results compile(SectionPos p_350790_, RenderChunkRegion p_350782_, VertexSorting p_350635_, SectionBufferBuilderPack p_350612_) {
        Results $$4 = new Results();
        BlockPos $$5 = p_350790_.origin();
        BlockPos $$6 = $$5.offset(15, 15, 15);
        VisGraph $$7 = new VisGraph();
        PoseStack $$8 = new PoseStack();
        ModelBlockRenderer.enableCaching();
        Reference2ObjectArrayMap $$9 = new Reference2ObjectArrayMap(RenderType.chunkBufferLayers().size());
        RandomSource $$10 = RandomSource.create();
        for (BlockPos blockPos : BlockPos.betweenClosed($$5, $$6)) {
            FluidState $$14;
            BlockEntity $$13;
            BlockState $$12 = p_350782_.getBlockState(blockPos);
            if ($$12.isSolidRender(p_350782_, blockPos)) {
                $$7.setOpaque(blockPos);
            }
            if ($$12.hasBlockEntity() && ($$13 = p_350782_.getBlockEntity(blockPos)) != null) {
                this.handleBlockEntity($$4, $$13);
            }
            if (!($$14 = $$12.getFluidState()).isEmpty()) {
                RenderType $$15 = ItemBlockRenderTypes.getRenderLayer($$14);
                BufferBuilder $$16 = this.getOrBeginLayer((Map<RenderType, BufferBuilder>)$$9, p_350612_, $$15);
                this.blockRenderer.renderLiquid(blockPos, p_350782_, $$16, $$12, $$14);
            }
            if ($$12.getRenderShape() != RenderShape.MODEL) continue;
            RenderType $$17 = ItemBlockRenderTypes.getChunkRenderType($$12);
            BufferBuilder $$18 = this.getOrBeginLayer((Map<RenderType, BufferBuilder>)$$9, p_350612_, $$17);
            $$8.pushPose();
            $$8.translate(SectionPos.sectionRelative(blockPos.getX()), SectionPos.sectionRelative(blockPos.getY()), SectionPos.sectionRelative(blockPos.getZ()));
            this.blockRenderer.renderBatched($$12, blockPos, p_350782_, $$8, $$18, true, $$10);
            $$8.popPose();
        }
        for (Map.Entry entry : $$9.entrySet()) {
            RenderType $$20 = (RenderType)entry.getKey();
            MeshData $$21 = ((BufferBuilder)entry.getValue()).build();
            if ($$21 == null) continue;
            if ($$20 == RenderType.translucent()) {
                $$4.transparencyState = $$21.sortQuads(p_350612_.buffer(RenderType.translucent()), p_350635_);
            }
            $$4.renderedLayers.put($$20, $$21);
        }
        ModelBlockRenderer.clearCache();
        $$4.visibilitySet = $$7.resolve();
        return $$4;
    }

    private BufferBuilder getOrBeginLayer(Map<RenderType, BufferBuilder> p_350651_, SectionBufferBuilderPack p_350965_, RenderType p_350494_) {
        BufferBuilder $$3 = p_350651_.get(p_350494_);
        if ($$3 == null) {
            ByteBufferBuilder $$4 = p_350965_.buffer(p_350494_);
            $$3 = new BufferBuilder($$4, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            p_350651_.put(p_350494_, $$3);
        }
        return $$3;
    }

    private <E extends BlockEntity> void handleBlockEntity(Results p_350754_, E p_350386_) {
        BlockEntityRenderer<E> $$2 = this.blockEntityRenderer.getRenderer(p_350386_);
        if ($$2 != null) {
            p_350754_.blockEntities.add(p_350386_);
            if ($$2.shouldRenderOffScreen(p_350386_)) {
                p_350754_.globalBlockEntities.add(p_350386_);
            }
        }
    }

    public static final class Results {
        public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final Map<RenderType, MeshData> renderedLayers = new Reference2ObjectArrayMap();
        public VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        public MeshData.SortState transparencyState;

        public void release() {
            this.renderedLayers.values().forEach(MeshData::close);
        }
    }
}

